# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 9
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR9_strategy.txt
# LLM Suggested Fallback: D

def harmony_optimizer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate trust factor based on opponent's past behavior
    trust_factor = sum(1 for m, o in zip(my_history, opp_history) if m == "C" and o == "C")
    round_num = len(my_history) + 1
    
    # Initial Trust-Building Phase (Rounds 1-3)
    if round_num == 1:
        return "C"  # Unconditional cooperation to appear trustworthy
    elif round_num == 2:
        return "C"  # Reinforce cooperative facade
    elif round_num == 3:
        return "D"  # Strategic defection to test opponent's tolerance
    
    # Adaptive Exploitation Phase (Rounds 4-7)
    elif 4 <= round_num <= 7:
        if round_num == 4:
            if opp_history[-1] == "C":  # Opponent forgave our defection
                return "D"  # Exploit their forgiveness
            else:
                return "C"  # Rebuild trust
        else:
            # Alternate based on opponent's recent moves
            if "D" not in opp_history[-2:]:
                return "D"  # Opponent is forgiving, defect
            else:
                return "C"  # Opponent is retaliatory, cooperate
    
    # Late-Game Aggression (Rounds 8-10)
    elif round_num >= 8:
        if "D" not in opp_history[-3:]:  # Opponent hasn't defected recently
            return "D"  # Defect aggressively
        else:
            if round_num == 10 and trust_factor > 3:  # Sneak in final defection if safe
                return "D"
            else:
                return "C"  # Maintain cooperation to avoid mutual destruction
    
    # Fallback (shouldn't reach here)
    return "C"